/*------------------------------------------------------------------------------*
 * File Name:				 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
// Including the system header file Origin.h should be sufficient for most Origin
// applications and is recommended. Origin.h includes many of the most common system
// header files and is automatically pre-compiled when Origin runs the first time.
// Programs including Origin.h subsequently compile much more quickly as long as
// the size and number of other included header files is minimized. All NAG header
// files are now included in Origin.h and no longer need be separately included.
//
// Right-click on the line below and select 'Open "Origin.h"' to open the Origin.h
// system header file.
#include <Origin.h>
////////////////////////////////////////////////////////////////////////////////////

//#pragma labtalk(0) // to disable OC functions for LT calling.

////////////////////////////////////////////////////////////////////////////////////
// Include your own header files here.
//#include "dragNdrop.h"

////////////////////////////////////////////////////////////////////////////////////
// Start your functions here.
///---Sim 05-12-2009 QA80-13594 MAKE_USER_IMPORT_OC_CODE_COMPATIBLE
#ifndef NO_LONGER_SUPPORT_80_USER_OC_TRICK_IMPORT_CODE

#define IMPORT_FUNC_PATH "OriginLab\\dragNdrop.C"

#define IMPORT_FUNC_NAME_IMPORT_FILES "import_files_ex"
typedef int (*FUNC_IMPORTFILES)(const StringArray& stDataFileName, LPCSTR strPageName, int nIndexLayer, TreeNode& trFilterSource, LPCSTR lpcszTypes, DWORD dwCntrl);
BOOL ImportFiles(StringArray& stDataFileName, LPCSTR strPageName, int nIndexLayer, TreeNode& trFilterSource, LPCSTR lpcszTypes)
{
	FUNC_IMPORTFILES fImportFiles;
	fImportFiles = Project.FindFunction(IMPORT_FUNC_NAME_IMPORT_FILES, IMPORT_FUNC_PATH, true);
	if ( fImportFiles )
	{
		return fImportFiles(stDataFileName, strPageName, nIndexLayer, trFilterSource, lpcszTypes, 0);
	}
	
	return false;	
}

#define IMPORT_FUNC_NAME_IMPORT_FILE "import_file_ex"
typedef int (*FUNC_IMPORTFILE)(LPCSTR strPageName, int nIndexLayer, LPCSTR lpcszDataFile, LPCSTR lpcszFilterName);
BOOL ImportFile(LPCSTR strPageName, int nIndexLayer, LPCSTR lpcszDataFile, LPCSTR lpcszFilterName)
{
	FUNC_IMPORTFILE fImportFile;
	fImportFile = Project.FindFunction(IMPORT_FUNC_NAME_IMPORT_FILE, IMPORT_FUNC_PATH, true);
	if ( fImportFile )
	{
		return fImportFile(strPageName, nIndexLayer, lpcszDataFile, lpcszFilterName);
	}
	
	return false;	
}

#define IMPORT_FUNC_NAME_LOAD_FILTER "load_import_filter_ex"
typedef int (*FUNC_LOADFILTER)(LPCSTR lpcszFilterName, LPCSTR lpcszDatFile, LPCSTR lpcszPageName, int nLocation, TreeNode& trFilter);
BOOL LoadFilter(string& strFilterName, String& strDatFile, string& strPageName, int location, TreeNode& trFilter)
{
	FUNC_LOADFILTER fLoadFilter;
	fLoadFilter = Project.FindFunction(IMPORT_FUNC_NAME_LOAD_FILTER, IMPORT_FUNC_PATH, true);
	if ( fLoadFilter )
	{
		return fLoadFilter(strFilterName, strDatFile, strPageName, location, trFilter);
	}
	
	return false;	
}

#define IMPORT_FUNC_NAME_IS_APPLICABLE "is_applicable_ex"
typedef int (*FUNC_ISAPPLICABLE)(TreeNode &trFilter, LPCSTR lpcszDataFile, LPCSTR lpcszTypes);
BOOL IsApplicable(TreeNode &trFilter, LPCSTR lpcszDataFile, LPCSTR lpcszTypes)
{
	FUNC_ISAPPLICABLE fIsApplicable;
	fIsApplicable = Project.FindFunction(IMPORT_FUNC_NAME_IS_APPLICABLE, IMPORT_FUNC_PATH, true);
	if ( fIsApplicable )
	{
		return fIsApplicable(trFilter, lpcszDataFile, lpcszTypes);
	}
	
	return false;	
}

#endif // NO_LONGER_SUPPORT_80_USER_OC_TRICK_IMPORT_CODE
///---END QA80-13594 MAKE_USER_IMPORT_OC_CODE_COMPATIBLE
